// H. Moessenboeck: Sprechen Sie Java? -- Kapitel 11, Aufgabe 3
// "Vektoren"

class Vector {
	double x, y;
	
	Vector(double x, double y) {
		this.x = x; this.y = y;
		normalize();
	}
	
	void normalize() {
		double len = Math.sqrt(x*x + y*y);
		x = x / len;
		y = y / len;
	}
	
	void add(Vector v) {
		x += v.x;
		y += v.y;
		normalize();
	}
	
	void multiply(double d) {
		x *= d;
		y *= d;
		normalize();
	}
	
	double scalarProduct(Vector v) {
		return x * v.x + y * v.y;
	}
	
	public String toString() {
		return "(" + x + "," + y + ")";
	}
}

public class A3 {
	
	public static void main(String args[]) {
		Vector v = new Vector(1, 0);
		v.add(new Vector(0, 1));
		Out.println("v = " + v);
		Out.println("scalar product = " + v.scalarProduct(new Vector(1, 2)));
	}
}
